import { notFound } from "next/navigation";
import dynamic from "next/dynamic";
import { FetchData } from "@/libs/api";
import { domain } from "@/domain/domain";
const OpenGallery = dynamic(() => import("@/sections/OpenGallery"));
const PropertyDetail = dynamic(() => import("@/sections/PropertyDetail"));
const HeroAbout = dynamic(() => import("@/sections/HeroAbout"));
const FarazForm = dynamic(() => import("@/sections/FarazForm"));
const HeroDetail = dynamic(() => import("@/sections/HeroDetail"));
const Amenities = dynamic(() => import("@/sections/Amenities"));
const SimpleMap = dynamic(() => import("@/sections/SimpleMap"));
const PaymentPlan = dynamic(() => import("@/sections/PaymentPlan"));
const FloorPlanDetail = dynamic(() => import("@/sections/FloorPlanDetail"));
const Brochure = dynamic(() => import("@/sections/Brochure"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const MortgageCalculator = dynamic(() =>
  import("@/sections/MortgageCalculator")
);
export async function generateMetadata({ params }) {
  const { project_detail } = params;
  const slug = project_detail;
  const data = await FetchData(slug);
  if (!data) {
    notFound();
  }
  const { project_info } = data;
  const {
    developer_name,
    community_name,
    property_name,
    bedrooms,
    type_names,
    coverImage,
  } = project_info;
  return {
    metadataBase: new URL(`https://${domain}/projects/${slug}`),
    title: `${property_name} by ${developer_name} at ${community_name}`,
    description: `{property_name} is the newly launched residential Project developed by ${developer_name} at ${community_name}, Offering ${bedrooms} ${property_name} in Dubai.`,
    keywords: ` ${property_name} by ${developer_name}, ${property_name} by ${community_name}, ${property_name} ${type_names}`,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
      images: {
        url: coverImage,
        width: 100,
        height: 100,
      },
    },
  };
}
export default async function page({ params }) {
  const { project_detail } = params;
  const slug = project_detail;
  const data = await FetchData(slug);
  if (!data) {
    notFound();
  }
  const currectUrl = `https:${domain}/projects/${slug}`;
  const { project_info, images, amenities, Floor_plan } = data;
  const {
    property_name,
    latitude,
    longitude,
    meta_title,
    meta_desc,
    meta_keywords,
  } = project_info;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}/${slug}`}
      />
      <RatingSchema title={meta_title} />
      <HeroDetail images={images} currectUrl={currectUrl} data={project_info} />
      <PropertyDetail data={project_info} />
      <HeroAbout data={project_info} image={images[0]?.image} />
      {amenities && amenities.length > 0 && <Amenities amenities={amenities} />}
      <PaymentPlan payment_plan={project_info} community_name={property_name} />
      <FloorPlanDetail Floor_plan={Floor_plan} property_name={property_name} />
      {longitude && longitude.length > 0 && (
        <SimpleMap
          lat={longitude}
          lag={latitude}
          property_name={property_name}
        />
      )}
      <OpenGallery
        interiorGallery={images}
        heading={`${property_name} Gallery`}
      />
      <MortgageCalculator />
      <FarazForm />
      <Brochure />
    </>
  );
}
